<?

class library extends item {

	public function __construct() {
		$this->set('library');
	}

	public function load() {
		return $this->load_sub();
	}

	private $parent_index = NULL;

	/*
		nota JSON i stadinn...

		uppfeara json fields jafnodum.
	*/

	public function load_sub($parent_id='-1') {
		$query = 'SELECT * FROM library WHERE parent_id = ? AND found_when_indexing = 1 ORDER BY LOWER(title)';
		$rows = $this->sql->get_rows($query, [$parent_id]);
		foreach($rows as $row) {
			if($row['is_folder'] == 0) {
				if($row['watch_count'] == (-1)) {
					$query = 'SELECT COUNT(*) as count FROM watch_log WHERE library_item_id = ?';
					$row['watch_count'] = $this->sql->get_row($query, [$row['id']])['count'];
				}
			}
			/*
				$row['children'] = $this->load_sub($row['id']);
				$ids = $object->map($row['children'], function($e) {
					return $e['id'];
				});

				$this->_([
					'id' => $row['id'],
					'child_ids' => $ids
				]);
			} else {*/
			if($row['child_ids'] != NULL && $object->strings->strlen($row['child_ids']) > 0) {
				$child_ids = $object->fromJSON($row['child_ids']);
				$row['children'] = $this->load_sub_alt($child_ids);
			} else {
				$row['children'] = $this->load_sub($row['id']);
				/*$ids = $object->map($row['children'], function($e) {
					return $e['id'];
				});

				$this->_([
					'id' => $row['id'],
					'child_ids' => $object->toJSON($ids)
				]);*/
			}
		}
		return $rows;
	}

	public function load_sub_alt($ids) {
		$res = [];
		foreach($ids as $id) {
			$query = 'SELECT * FROM library WHERE id = ?';
			$row = $this->sql->get_row($query, [$id]);
			$res[] = $row;
			if($row['child_ids'] != NULL && $object->strings->strlen($row['child_ids']) > 0) {
				$child_ids = $object->fromJSON($row['child_ids']);
				$row['children'] = $this->load_sub_alt($child_ids);
			} else {
				$row['children'] = $this->load_sub($row['id']);
			}
		}
		return $res;
	}

	public function get_or_insert($parent_path) {
		if($parent_path->length == 0) {
			return (-1);
		}

		$is_template_item = 0;



		if($parent_path->length == 2) {
			$is_template_item = 1;
		}

		$parent_value = $object->strings->join($parent_path, '/');
		$parent_value = $object->regex->preg_replace('\/+', '/', $parent_value);
		/*if($object->isset($this->parent_index[$parent_value])) {
			return $this->parent_index[$parent_value];
		}*/

		/*$object->log($object->toJSON([$parent_value, $parent_path]));*/


		$set_index = $parent_path->length - 1;

		$folder_title = $object->splice($parent_path, $set_index, 1)[0];

		$query = 'SELECT * FROM library WHERE relativepath = ?';
		$row = $this->sql->get_row($query, [$parent_value]);

		$id = NULL;
		if($row == NULL) {
			$parent = $this->get_or_insert($parent_path); 
			/*if($parent == (-1)) {*/

			return $this->_([
				'title' => $folder_title,
				'relativepath' => $parent_value,
				'is_folder' => 1,
				'is_active' => 1,
				'parent_id' => $parent,
				'is_template_item' => $is_template_item,
				'found_when_indexing' => 1
			]);
		} else {
			$this->parent_index[$parent_value] = $id;
			$id = $row['id'];
		}

		return $id;
	}

	public function update($rows, $locations) {
		$object->log('in update');

		$this->parent_index = $object->create();

		$object->log('sort start');

		$object->sort($rows, function($a, $b) {
			return $object->strings->compare($a['kMDItemPath'], $b['kMDItemPath']);
		});

		$object->log('sort stopped');

		$set_index_values = $object->create();

		$last_parent = NULL;

		$parent_children = [];

		foreach($rows as $row) {
			$path = $row['kMDItemPath'];

			$relative_full_path = NULL;
			
			/*$object->log($object->toJSON([$path]));*/

			foreach($locations as $location) {
				if($relative_full_path == NULL && $object->strings->strpos($path, $location) === 0) {
					$relative_full_path = $object->strings->substr($path, $object->strings->strlen($location));
				}
			}

			/*$object->log('relative full path: '.$relative_full_path);*/

			$path_components = $files->path_components($relative_full_path);

			/*$object->log($object->toJSON($path_components));*/

			$set_index = $path_components->length - 1;

			/*$object->log($set_index);*/

			$spliced = $object->splice($path_components, $set_index, 1);

			/*$object->log($spliced[0]);

			$object->log($object->toJSON($path_components));*/

			$media_item_title = $spliced[0];

			/*$object->log($object->toJSON([$path_components]));*/

			$parent = $this->get_or_insert($path_components);


			$query = 'SELECT * FROM library WHERE relativepath = ?';
			$row = $this->sql->get_row($query, [$relative_full_path]);
			
			if($last_parent != $parent) {
				if($last_parent != NULL) {
					$this->_([
						'id' => $last_parent,
						'child_ids' => $object->toJSON($parent_children)
					]);
					$parent_children = [];
				}
				$object->log('switched parent: '.$last_parent.' - '.$parent);


				$last_parent = $parent;
			}

			if($row == NULL) {
				$set_id_res = $this->_([
					'title' => $media_item_title,
					'relativepath' => $relative_full_path,
					'is_folder' => 0,
					'is_active' => 1,
					'parent_id' => $parent,
					'found_when_indexing' => 1,
					'watch_count' => 0
				]);
				$set_index_values[$set_id_res] = true;
				$parent_children[] = $set_id_res;
			} else {
				$set_index_values[$row['id']] = true;
				$parent_children[] = $row['id'];
			}

		
		}

		$object->log('completed');

		$query = 'SELECT * FROM library WHERE is_folder = 0';
		$set_rows = $this->sql->get_rows($query, []);

		foreach($set_rows as $set_row) {
			if(!$object->isset($set_index_values[$set_row['id']])) {
				$this->_([
					'id' => $set_row['id'],
					'found_when_indexing' => 0
				]);
			}
		}

	}
}

?>